﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
*/
#include "gameFunctions/nestedEval.as"
#include "functions/sendEvent.as"
// run()
define_event = function( thisCommand_obj ){
	
	
	// Get the event's name
	var evt_str = nestedEval( thisCommand_obj.data.name, defaultContainer_str, thisContainer_str );
	
	// Sanity check
	var isValid = true;
	if( !evt_str )		isValid = false;
	
	
	if( isValid ){
		// Get the object where the event should occur
		var path = "[" + thisCommand_obj.data.path + "]";		// Always assume the path is a variable-path to something
		var evtEmitter = nestedEval( path, defaultContainer_str, thisContainer_str );
		var emitterIsObject = ( evtEmitter instanceof Object );
		if( !emitterIsObject )		evtEmitter = undefined;
		
		// Get variables to send with the event
		var evt = {};
		evt.type = evt_str;
		var dat = thisCommand_obj.data.data;
		for( var nam in dat ){
			var val = nestedEval(  dat[ nam ],  defaultContainer_str, thisContainer_str );
			evt[ nam ] = val;
		} // for:  each variable to send with the event
		delete val;
		
		// Debug trace
		if(TRACE_SCRIPT){
			trace("event:  "+thisCommand_obj.data.name + "  ("+thisCommand_obj.data.path+")");
			/*	
			trace("event:  "+thisCommand_obj.data.name + "  ("+thisCommand_obj.data.path+")  Listing evt contents:");
			for( var nam in evt ){
				trace( "  " + nam + ":  " + evt[ nam ]  );
				for( var nam2 in evt[ nam ] ){
					trace( "    " + nam2 + ":  " + evt[ nam ][ nam2 ]  );
				} 
			}// each item in evt
			trace( "- - - -" );
			*/
		}// if:  TRACE_SCRIPT
		
		// Send the event itself
		sendEvent( evt_str, evt, evtEmitter );
	} // if:  data is valid
	
	
	// instantly done
	return VOW.make().keep();
	
	
}// define_event()